<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" indent="yes" encoding="utf-8" omit-xml-declaration="yes"/>

	<xsl:variable name="tab" select="'&#09;'" />

	<xsl:template match="SetupSheetData/ReportHeading">
		<html>
    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE9" />
			<head>
				<basefont face="Verdana"/>
   </head>
   <body>
    <BR/>
     <TABLE align="center">
       <TR align="center">
         <TD style="FONT: 23pt Times">
           <B>SOLIDWORKS CAM (Powered by CAMWorks)</B>
         </TD>
       </TR>

    <xsl:for-each select="./Heading">
      <TR  align="center">
        <TD style="FONT: 23pt Times">
          <xsl:value-of select="."/>
        </TD>
      </TR>
    </xsl:for-each>

     </TABLE>
     <BR/><HR SIZE="1" COLOR="#6E0204"/>
   </body>
  </html>
	</xsl:template>

	<xsl:template match="SetupSheetData/Data">
	<html>

		<STYLE>
		  BODY
		  {
		  BACKGROUND-POSITION: right bottom;
		  BACKGROUND-ATTACHMENT: fixed;
		  MARGIN-LEFT: 10pt;
		  background-color:#ffffff;
		  BACKGROUND-REPEAT: no-repeat;
		  }

		  .WIPImg
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLOR: #e0dee3;
		  CURSOR: hand;
		  }

		  .WIPImgMouseOver
		  {
		  BORDER-RIGHT:#6666ff  1px solid;
		  BORDER-TOP:#6666ff  1px solid;
		  BORDER-LEFT:#6666ff  1px solid;
		  BORDER-BOTTOM:#6666ff  1px solid;
		  BORDER-COLOR: #6666ff;
		  CURSOR: hand;
		  }

		  .EE
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  FONT: 10 pt;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .EE TD
		  {
		  BORDER-TOP:#e0dee3  1px solid;
		  PADDING-RIGHT: 5px;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  FONT: 8pt verdana;
		  BORDER-COLOR: #e0dee3;
		  }

		  .EE TH
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  font-style:strong;
		  BORDER-COLOR: #e0dee3;
		  }

		  .clsResultSummary
		  {
		  BORDER-RIGHT:#e0dee3  1px solid;
		  BORDER-TOP:#e0dee3  1px solid;
		  BORDER-LEFT:#e0dee3  1px solid;
		  BORDER-BOTTOM:#e0dee3  1px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  FONT: 8 pt;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .clsResultSummary TD
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px
		  }

		  .clsResultSummary TH
		  {
		  PADDING-RIGHT: 5px;
		  BORDER-TOP: #e0dee3 1px solid;
		  PADDING-LEFT: 5px;
		  HEIGHT: 23px;
		  font-style: strong;
		  font-family: Arial;
		  }

		  .DivCls
		  {
		  BORDER-RIGHT:#e0dee3  0px solid;
		  BORDER-TOP:#e0dee3  0px solid;
		  BORDER-LEFT:#e0dee3  0px solid;
		  BORDER-BOTTOM:#e0dee3  0px solid;
		  BORDER-COLLAPSE: collapse;
		  EMPTY-CELLS: show;
		  COLOR: BLACK;
		  BORDER-COLOR: #e0dee3;
		  }
		  .DivCls TD
		  {
		  PADDING-RIGHT: 0px;
		  PADDING-LEFT: 0px;
		  PADDING-TOP: 0px;
		  PADDING-BOTTOM: 0px;
		  }

		  .DivCls TH
		  {
		  PADDING-RIGHT: 0px;
		  PADDING-LEFT: 0px;
		  PADDING-TOP: 0px;
		  PADDING-BOTTOM: 0px;
		  }
		  
	  </STYLE>
			<body> 
			
			<BR/><font color="#01106D" size="5"><B></B></font><BR/>
				<table border="0" align="center">  
				<tr>
					<td>
				<table class="clsResultSummary" border="1" align="Left" CELLPADDING="5">
					 
						<xsl:for-each select="*">
							<xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
                  <td>Company</td>
                  <td>
                    <xsl:value-of select="@CustomInfoCompanyName"/>
                  </td>
                </tr>
              </xsl:if>	     
			
							 <xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
                  <td>Date/Time</td>
                  <td>
                    <xsl:value-of select="@CustomInfoDateTime"/>
                  </td>
                </tr>
              </xsl:if>
			
							 <xsl:if test="name() = 'rep_WorkPiece'">
                <tr>
                  <td>Material</td>
                  <td>
                    <xsl:value-of select="@WorkPieceMaterial"/>
                  </td>
                </tr>
              </xsl:if>
			
				<xsl:if test="name() = 'rep_WorkPiece'">
                <tr>
                  <td>Stock Size</td>
                  <td>
				  <xsl:variable name = "strProgramName">
						<xsl:value-of select="@WorkPieceTypeName"/>
						</xsl:variable>
						<xsl:if test="$strProgramName ='Cylindrical'">														
							Dia : <xsl:value-of select="@WorkPieceMaxDia"/>, Length : <xsl:value-of select="@WorkPieceLength"/>
						</xsl:if>
						
						<xsl:if test="not($strProgramName ='Cylindrical')">														
							<xsl:value-of select="@WorkPieceLength"/>, <xsl:value-of select="@WorkPieceWidth"/>, <xsl:value-of 	 				select="@WorkPieceHeight"/>
						</xsl:if>
                  </td>
                </tr>
              </xsl:if>
						</xsl:for-each>      
					</table>
				</td>

				<td>
					<!--Table for SOLIDWORKS DATA and related stuff-->
					 <table class="clsResultSummary" border="1" align="Left" CELLPADDING="5">  
						<xsl:for-each select="*">
							<xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
                  <td>Author</td>
                  <td>
                    <xsl:value-of select="@CustomInfoAuthor"/>
                  </td>
                </tr>
              </xsl:if>
				
						<xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
                  <td>Keywords</td>
                  <td>
                    <xsl:value-of select="@CustomInfoKeywords"/>
                  </td>
                </tr>
              </xsl:if>

							 <xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
                  <td>Comments</td>
                  <td>
                    <xsl:value-of select="@CustomInfoComments"/>
                  </td>
                </tr>
              </xsl:if>
				  
						<xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
                  <td>Title</td>
                  <td>
                    <xsl:value-of select="@CustomInfoTitle"/>
                  </td>
                </tr>
              </xsl:if>
						</xsl:for-each>      
					</table>
				</td>
          <td>
					<!--Table for Part File and related stuff-->
					 <table class="clsResultSummary" border="1" align="Left" CELLPADDING="5">
						<xsl:for-each select="*">  
							<xsl:if test="name() = 'rep_MchParams'">
                <tr>
                  <td>CNC Mach</td>
                  <td>
                    <xsl:value-of select="@MchName"/>
                  </td>
                </tr>
              </xsl:if>
						
							<xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
                  <td>Programmer</td>
                  <td>
                    <xsl:value-of select="@CustomInfoProgrammer"/>
                  </td>
                </tr>
              </xsl:if>

							<xsl:if test="name() = 'rep_Doc'">
                <tr>
                  <td>Units</td>
                  <td>
                    <xsl:value-of select="@Unit"/>
                  </td>
                </tr>
              </xsl:if>
					  
						<xsl:if test="name() = 'rep_CustomInfo'">
                <tr>
                  <td>Subject</td>
                  <td>
                    <xsl:value-of select="@CustomInfoSubject"/>
                  </td>
                </tr>
              </xsl:if>

						</xsl:for-each>      
					</table>
</td>

            </tr>
        </table>
					<!--End of Table for PartFile and related stuff-->
					<!--Gap between header info and operation related info-->
				
					
					
	<BR></BR>
	<BR/><HR SIZE="3"/>	 
	<BR></BR>

	<xsl:for-each select="*"> 
								<xsl:if test="name() = 'rep_MchPosting'">
									<BR></BR>
									<BR></BR>
									
									<table style="BORDER-COLLAPSE: collapse;" align="center" border="1" bordercolor="gray">
				<tr>
                  <td>
					
					<table class="clsResultSummary" width="1085" height="100%" border="1" align="Left" CELLPADDING="3"> 
												<tr>
													<td colspan = "2" align="Center">Machine Posting Parameters</td>
												</tr>
												<xsl:for-each select="*">
													<xsl:if test="name() = 'Param'"> 
														<tr>
															<td> <xsl:value-of 			select="@Name"/> </td>
															<td> <xsl:value-of 			select="@Value"/> </td>		 
														</tr>
													</xsl:if>
												</xsl:for-each> <!--for each tag under Machine Posting Parameters--> 
											</table>
										
									</td>
								</tr>
								</table>
								
								</xsl:if>
							</xsl:for-each>

		

	<xsl:for-each select="*">

        <xsl:if test="name() = 'MillSetupSheetAttr'">
		 
          <xsl:for-each select="*">

            <xsl:if test="name() = 'rep_SetupAttr'">
			 <BR></BR>
              <BR></BR>
              <!--if tag is rep_SetupAttr -->
              <table class="clsResultSummary" border="1" align="center" CELLPADDING="5" width="80%" bgcolor="#FFFFD6">
                <tr>
                  <th>
                    Setup No.
                  </th>
                  <th>
                    Setup Name
                  </th>
                  <th>
                    Setup Origin
                  </th>
                  <th>
                    Mach Time(MIN)
                  </th>
                </tr>
                <tr align="center">
                  <td>
                        <xsl:value-of select="@SetupAttrSetupNo"/>
                  </td>
                  <td>
                        <xsl:value-of select="@SetupAttrSetupName"/>
                  </td>
                  <td>
                        <xsl:value-of select="@SetupAttrCoordX"/>, 		<xsl:value-of select="@SetupAttrCoordY"/>, <xsl:value-of 		select="@SetupAttrCoordZ"/>
                  </td>
                  <td>
                        <xsl:value-of select="@SetupAttrMachTime"/>
                  </td>
                </tr>
              </table>
			
            </xsl:if>
			
					
	
	
	
		<xsl:if test="name() = 'PostOperation'">
			<BR></BR>
		    <BR></BR>
		    
			<table style="BORDER-COLLAPSE: collapse;" align="center" border="1" bordercolor="gray">
               
										<tr><td><BR></BR><!--Start To Cover Eatch 'PostOperation'-->
						
											<!--Details of the PostOperation-->
											<table class="clsResultSummary" width="400" height="100%" border="1" align="Left" CELLPADDING="3">
												<xsl:for-each select="*">	
													<xsl:if test="name() = 'rep_Operation'"> 	
														<tr>    
															<td>Operation</td>
															<td colspan = "2">  <xsl:value-of 			select="@OperationName"/> </td>
														</tr> 		   
													</xsl:if>
													<xsl:if test="name() = 'Param'"> 
														<tr>
															<td> <xsl:value-of 			select="@Name"/> </td> 		   
															<td> <xsl:value-of 			select="@Value"/></td>		 
														</tr>
													</xsl:if>
													<BR></BR>
												</xsl:for-each> <!--for each tag under PostOperation--> 
											</table>
										
										</td></tr><!--End To Cover 'PostOperation'-->
			</table>
			</xsl:if>
					
					
			<xsl:if test="name() = 'MillOperation'">
              <!--Details of the Mill Oprations-->
              <BR></BR>
              <BR></BR>
             
              <table style="BORDER-COLLAPSE: collapse;" align="center" border="1" bordercolor="gray">
                <tr>
                  <td>
				<table class="clsResultSummary" width="400" height="100%" border="1" align="Left" CELLPADDING="3">
                <xsl:for-each select="*">

              
				  
				  
				  <xsl:if test="name() = 'rep_Tool'"> 	
														<tr>    
															<td>Tool Station no.</td>
															<td><xsl:value-of select="@ToolStnNo"/></td>
														</tr> 		   
													</xsl:if>
							
													<xsl:if test="name() = 'rep_Operation'"> 	
														<tr>    
															<td>Operation</td>
															<td><xsl:value-of select="@OperationName"/></td>
														</tr> 		   
													</xsl:if>
							  
					<xsl:if test="name() = 'rep_Operation'"> 	
														<tr>    
															<td>Operation Desc</td>
															<td><xsl:value-of select="@Description"/></td>
														</tr> 		   
													</xsl:if>
													
													
													
													
													
													<xsl:if test="name() = 'rep_Tool'"> 
														<tr>
															<td>Tool Description</td>
															<td><xsl:value-of select="@ToolComment"/></td>
														</tr>
													</xsl:if> 

													<xsl:if test="name() = 'rep_MillHolderLibrary'"> 
														<tr>
															<td>Holder Description</td>
															<td><xsl:value-of select="@HolderComment"/></td>
														</tr>
													</xsl:if> 

													<xsl:if test="name() = 'rep_MillHolderLibrary'"> 
														<tr>
															<td>Holder Number</td>
															<td><xsl:value-of select="@HolderNumber"/></td>
														 </tr>
													</xsl:if> 
								
													<xsl:if test="name() = 'rep_MillOperParams'"> 
														<tr>
															<td>Speed (RPM)</td>
															<td><xsl:value-of select="@MillSpindleSpeed"/></td>
														</tr>
													</xsl:if>   

													<xsl:if test="name() = 'rep_MillOperParams'"> 
														<tr>
															<td>Feed</td>
															<td><xsl:value-of select="@XYFeedRate"/></td>
														</tr>
													</xsl:if>   

													<xsl:if test="name() = 'rep_MillOperParams'"> 
														<tr>
															<td>Z Feed Rate</td>
															<td><xsl:value-of select="@ZFeedRate"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinType != 'N.A.'"> 
														<tr>
															<td>Lead in Type</td>
															<td><xsl:value-of select="@LeadinType"/></td>
														</tr>
													</xsl:if>

													 <xsl:if test="@LeadinAmt != 'N.A.'"> 
														<tr>
															<td>Lead in Amount</td>
															<td><xsl:value-of select="@LeadinAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinAmtPercent != 'N.A.'"> 
														<tr>
															<td>Lead in Amount(%)</td>
															<td><xsl:value-of select="@LeadinAmtPercent"/></td>
														</tr>
													</xsl:if>

													<xsl:if test="@LeadinAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Lead in Amount</td>
															<td><xsl:value-of select="@LeadinAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinOverlap != 'N.A.'"> 
														<tr>
															<td>Lead in Overlap</td>
															<td><xsl:value-of select="@LeadinOverlap"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinOverlapPercent != 'N.A.'"> 
														<tr>
															<td>Lead in Overlap(%)</td>
															<td><xsl:value-of select="@LeadinOverlapPercent"/></td>
														</tr>
													</xsl:if>

													<xsl:if test="@LeadinOverlapAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Lead in Overlap</td>
															<td><xsl:value-of select="@LeadinOverlapAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinArcRadius != 'N.A.'"> 
														<tr>
															<td>Lead in Arc Radius</td>
															<td><xsl:value-of select="@LeadinArcRadius"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinArcRadiusPercent != 'N.A.'"> 
														<tr>
															<td>Lead in Arc Radius(%)</td>
															<td><xsl:value-of select="@LeadinArcRadiusPercent"/></td>
														</tr>
													</xsl:if>

													<xsl:if test="@LeadinArcRadiusAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Lead in Arc Radius</td>
															<td><xsl:value-of select="@LeadinArcRadiusAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinArcAngle != 'N.A.'"> 
														<tr>
															<td>Lead in Arc Angle</td>
															<td><xsl:value-of select="@LeadinArcAngle"/></td>
														</tr>
													</xsl:if>
															
													<xsl:if test="@LeadoutType != 'N.A.'"> 
														<tr>
															<td>Lead out Type</td>
															<td><xsl:value-of select="@LeadoutType"/></td>
														</tr>
													</xsl:if>

													<xsl:if test="@LeadOutAmt != 'N.A.'"> 
														<tr>
															<td>Lead out Amount</td>
															<td><xsl:value-of select="@LeadOutAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutAmtPercent != 'N.A.'"> 
														<tr>
															<td>Lead out Amount(%)</td>
															<td><xsl:value-of select="@LeadoutAmtPercent"/></td>
														</tr>
													</xsl:if>

													<xsl:if test="@LeadoutAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Lead out Amount</td>
															<td><xsl:value-of select="@LeadoutAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutOverlap != 'N.A.'"> 
														<tr>
															<td>Lead out Overlap</td>
															<td><xsl:value-of select="@LeadoutOverlap"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutOverlapPercent != 'N.A.'"> 
														<tr>
															<td>Lead out Overlap(%)</td>
															<td><xsl:value-of select="@LeadoutOverlapPercent"/></td>
														</tr>
													</xsl:if>

													<xsl:if test="@LeadoutOverlapAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Lead out Overlap</td>
															<td><xsl:value-of select="@LeadoutOverlapAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutArcRadius != 'N.A.'"> 
														<tr>
															<td>Lead out Arc Radius</td>
															<td><xsl:value-of select="@LeadoutArcRadius"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutArcRadiusPercent != 'N.A.'"> 
														<tr>
															<td>Lead out Arc Radius(%)</td>
															<td><xsl:value-of select="@LeadoutArcRadiusPercent"/></td>
														</tr>
													</xsl:if>

													<xsl:if test="@LeadoutArcRadiusAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Lead out Arc Radius</td>
															<td><xsl:value-of select="@LeadoutArcRadiusAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutArcAngle != 'N.A.'"> 
														<tr>
															<td>Lead out Arc Angle</td>
															<td><xsl:value-of select="@LeadoutArcAngle"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinClearance != 'N.A.'"> 
														<tr>
															<td>Lead in clearance</td>
															<td><xsl:value-of select="@LeadinClearance"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinClearancePercent != 'N.A.'"> 
														<tr>
															<td>Lead in clearance(%)</td>
															<td><xsl:value-of select="@LeadinClearancePercent"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadinClearanceAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Lead in clearance</td>
															<td><xsl:value-of select="@LeadinClearanceAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutClearance != 'N.A.'"> 
														<tr>
															<td>Lead out clearance</td>
															<td><xsl:value-of select="@LeadoutClearance"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutClearancePercent != 'N.A.'"> 
														<tr>
															<td>Lead out clearance(%)</td>
															<td><xsl:value-of select="@LeadoutClearancePercent"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@LeadoutClearanceAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Lead out clearance</td>
															<td><xsl:value-of select="@LeadoutClearanceAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@PassClearance != 'N.A.'"> 
														<tr>
															<td>Pass clearance</td>
															<td><xsl:value-of select="@PassClearance"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@PassClearancePercent != 'N.A.'"> 
														<tr>
															<td>Pass clearance(%)</td>
															<td><xsl:value-of select="@PassClearancePercent"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="@PassClearanceAdditionalAmt != 'N.A.'"> 
														<tr>
															<td>Additional Pass clearance</td>
															<td><xsl:value-of select="@PassClearanceAdditionalAmt"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="name() = 'rep_Relation'"> 
														<tr>
															<td>Mach Depth</td>
															<td><xsl:value-of select="@RelationMachDepth"/></td>
														</tr>
													</xsl:if>
													
													<xsl:if test="name() = 'rep_MillOperParams'"> 
													 <xsl:if test="@BottomAllowance != 'N.A.'"> 
														  <tr>
														  <td>Bottom Allowance</td>
														  <td><xsl:value-of select="@BottomAllowance"/></td>
														 </tr>
													 </xsl:if>	
													</xsl:if>
													
													<xsl:if test="name() = 'rep_MillOperParams'"> 
													 <xsl:if test="@SideAllowance != 'N.A.'"> 
														 <tr>
														  <td>Side Allowance</td>
														  <td><xsl:value-of select="@SideAllowance"/></td>
														 </tr>
													 </xsl:if>
													</xsl:if>

													<xsl:if test="name() = 'rep_MillOperParams'"> 
														<tr>
															<td>Tool Protrusion Length</td>
															<td><xsl:value-of select="@MinToolProtusionLength"/></td>
														</tr>
													</xsl:if>

													<xsl:if test="name() = 'rep_Relation'">
														<tr><td colSpan="2">
															<table class="clsResultSummary" width ="400" border="1" align="center" CELLPADDING="3">
																 <tr>
																	<td width="20%"></td>
																	<td width="40%">Minimum</td>
																	<td width="40%">Maximum</td>
																 </tr>
																<tr>
																	<td>X:</td>
																	<td><xsl:value-of select="@MinX"/></td>
																	<td><xsl:value-of select="@MaxX"/></td>
																</tr>
																<tr>
																	<td>Y:</td>
																	<td><xsl:value-of select="@MinY"/></td>
																	<td><xsl:value-of select="@MaxY"/></td>
																</tr>
																<tr>
																	<td>Z:</td>
																	<td><xsl:value-of select="@MinZ"/></td>
																	<td><xsl:value-of select="@MaxZ"/></td>
																</tr>
															</table>
														</td></tr>
													</xsl:if>
										
													<xsl:if test="name() = 'rep_Relation'"> 
														<tr>
															<td>Tlp Len</td>
															<td><xsl:value-of select="@RelationTlpLen"/></td>
														</tr>
													</xsl:if> 

													<xsl:if test="name() = 'rep_Relation'"> 
													<tr>
														<td>Time (MIN)</td>
														<td><xsl:value-of select="@RelationTime"/></td>
													</tr>
												</xsl:if>
								
													<xsl:for-each select="*">	
														<xsl:if test="name() = 'Param'"> 
															<tr>    
																<td> <xsl:value-of 			select="@Name"/> </td>
																<td> <xsl:value-of 			select="@Value"/></td>		 
															</tr>
														</xsl:if>
													</xsl:for-each> <!--for each tag under SubSpindleOperation-->
													
												
													
							
													
													
													<xsl:if test="@PassClearance != 'N.A.'"> 
														<tr>
															<td>Pass clearance</td>
															<td><xsl:value-of select="@PassClearance"/></td>
														</tr>
													</xsl:if>
													
													
					
					</xsl:for-each>
					</table>
					</td>
					<td>
					
					 <!--ADD IMAGE TO THE SETUP SHEET -->
					<xsl:for-each select="*">	
						<xsl:if test="name() = 'rep_Operation'"> 
							<xsl:variable name = "imageUrl"><xsl:value-of select="@ImagePath"/></xsl:variable>
							<!-- <xsl:if test="$imageUrl !=''">-->
                            <xsl:text disable-output-escaping="yes">&lt;img src="</xsl:text>
							<xsl:value-of select="$imageUrl"/>
							<xsl:text disable-output-escaping="yes">"&#160;WIDTH="400" HEIGHT="400" /&gt;</xsl:text>
							<!--<BR></BR>-->
						</xsl:if>
					</xsl:for-each>
					
					<xsl:for-each select="*">
                        <xsl:if test="name() = 'rep_ToolImagePath'">
                          <xsl:variable name = "imageUrl">
                            <xsl:value-of select="@ToolImagePath"/>
                          </xsl:variable>
                          <xsl:if test="$imageUrl !=''">
                            
                            <xsl:text disable-output-escaping="yes">&lt;img src="</xsl:text>
							<xsl:value-of select="$imageUrl"/>
							<xsl:text disable-output-escaping="yes">"&#160;WIDTH="75" HEIGHT="150" align="Top" hspace="100" /&gt;</xsl:text>
                          </xsl:if>
                        </xsl:if>
                      </xsl:for-each>
					
					</td>
                  </tr>
					</table>
					</xsl:if>
					
					 </xsl:for-each>
          <!-- for each tag under MillSetupSheetAttr-->

          <!-- Placing divider line between two setup sheets -->
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR></BR>
          <BR/>
          <HR SIZE="3"/>
          <BR></BR>
					
								</xsl:if>

			</xsl:for-each>
					
			</body>
		</html>
	</xsl:template>


</xsl:stylesheet>